/**
* \file: ServerMonitor.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/



#include <map>
#include <string>
#include <semaphore.h>
#include <mutex>              // std::mutex, std::unique_lock
#include <condition_variable> // std::condition_variable
#include <bdcl/AoapTransport.h>

#include "utils/DeviceMonitor.h"
#include <uspi/FeatureDiscoveryTypes.h>

#include <utils/GadgetLoader.h>
#include <utils/iAP2EANativeSession.h>
#include "utils/EventDispatcher.h"

namespace adit { namespace bdcl {

class ServerMonitor : public DeviceMonitor
{
public:
	std::mutex discovererMutex;
	std::condition_variable discovererCV;

    bool start(uint32_t inEventMask);
    void stop();

private:
    void onDeviceFound(std::shared_ptr<adit::uspi::DiscoveredDevice> inDevice);
    void onDeviceLost(std::shared_ptr<adit::uspi::DiscoveredDevice> inDevice);
    void onDeviceSwitched(std::shared_ptr<adit::uspi::DiscoveredDevice> inDevice);
    void onDeviceChanged(std::shared_ptr<adit::uspi::DiscoveredDevice> inDevice);

};


} } /* namespace adit { namespace bdcl */

